<?php
session_start();
include "../connection.php"; 

if (!isset($_SESSION['userid'])) {
    if (isset($_COOKIE['userid'])) {
        $_SESSION['userid'] = $_COOKIE['userid'];
    } else {
        header("Location: ../login.php");
        exit();
    }
}

// Fetch the user ID from the session
$userid = $_SESSION['userid'];

// Query to get the total added money for the logged-in user
$sql = "SELECT SUM(taka) AS totalAddMoney FROM balance_history WHERE userid = ? AND status = 'Accepted' ";
$stmt = $con->prepare($sql);
$stmt->bind_param("i", $userid);
$stmt->execute();
$stmt->bind_result($totalAddMoney);
$stmt->fetch();
$stmt->close();

$totalAddMoney = $totalAddMoney ?? 0; 

// Query to get the total added money for the logged-in user
$sql = "SELECT SUM(amount) AS totalMobileTopUp FROM mobile_topup WHERE userid = ? AND status = 'Accepted' ";
$stmt = $con->prepare($sql);
$stmt->bind_param("i", $userid);
$stmt->execute();
$stmt->bind_result($totalMobileTopUp);
$stmt->fetch();
$stmt->close();


$totalMobileTopUp = $totalMobileTopUp ?? 0; 

// Query to get the total added money for the logged-in user
$sql = "SELECT SUM(amount) AS totalMobileBanking FROM mobile_banking WHERE userid = ? AND status = 'Accepted' ";
$stmt = $con->prepare($sql);
$stmt->bind_param("i", $userid);
$stmt->execute();
$stmt->bind_result($totalMobileBanking);
$stmt->fetch();
$stmt->close();


$totalMobileBanking = $totalMobileBanking ?? 0; 

// Query to get the total added money for the logged-in user
$sql = "SELECT SUM(amount) AS totalBanking FROM banking WHERE userid = ? AND status = 'Accepted' ";
$stmt = $con->prepare($sql);
$stmt->bind_param("i", $userid);
$stmt->execute();
$stmt->bind_result($totalBanking);
$stmt->fetch();
$stmt->close();


$totalBanking = $totalBanking ?? 0; 

// Query to get the total added money for the logged-in user
$sql = "SELECT SUM(amount) AS totalBillPay FROM bill_pay WHERE userid = ? AND status = 'Accepted' ";
$stmt = $con->prepare($sql);
$stmt->bind_param("i", $userid);
$stmt->execute();
$stmt->bind_result($totalBillPay);
$stmt->fetch();
$stmt->close();


$totalBillPay = $totalBillPay ?? 0; 

// Step 1: Retrieve accepted offer requests for the logged-in user
$sql = "SELECT dp.offer_rqst 
        FROM drive_package_rqst dp 
        WHERE dp.userid = ? AND dp.status = 'Accepted'";

$stmt = $con->prepare($sql);
$stmt->bind_param("i", $userid);
$stmt->execute();
$result = $stmt->get_result();

// Step 2: Prepare for summation
$totalPackBuy = 0;

// Step 3: For each accepted offer request, fetch the total from all_drive_package
while ($row = $result->fetch_assoc()) {
    $offerId = $row['offer_rqst'];

    $totalSql = "SELECT drive_total FROM all_drive_package WHERE offer_id = ?";
    $totalStmt = $con->prepare($totalSql);
    $totalStmt->bind_param("i", $offerId);
    $totalStmt->execute();
    $totalStmt->bind_result($driveTotal);
    $totalStmt->fetch();
    
    $totalPackBuy += $driveTotal ?? 0; // Safely add the total
    $totalStmt->close();
}





// Query to get the total added money for the logged-in user
$sql = "SELECT SUM(taka) AS totalSendMoney FROM send_reseller_history WHERE userid = ? AND status = 'Successful' ";
$stmt = $con->prepare($sql);
$stmt->bind_param("i", $userid);
$stmt->execute();
$stmt->bind_result($totalSendMoney);
$stmt->fetch();
$stmt->close();


$totalSendMoney = $totalSendMoney ?? 0; 

?>

<?php include 'header-link.php' ?>

<main>

	<?php include 'top-bar.php' ?>

    <section>
        <div class="container mt-2 pb-5">
            <div class="row justify-content-center">
                <div class="col-md-6">
                    <div class="card custom-card">
                        <div class="card-body text-center"> 
								<i class="profile-icon fa-regular fa-rectangle-history-circle-plus fa-2x"></i>
                            <h6 class="card-title my-3"> ট্রান্জেকশন হিস্টোরি </h6>

                            <div class="offer-list" id="offerList">
                                <div class="offer-card mb-3  p-3">
                                    <div class="row">
									
                                        <div class="col-md-12 text-center">
                                            <small> সর্বমোট এড মানি </small><br>
                                            <small class="fw-bold"> <?php echo htmlspecialchars(number_format($totalAddMoney),2); ?> টাকা</small><br>
                                            <a href="work-ongoing.php" class="btn custom-button w-50 mx-auto"> হিস্টোরি  দেখুন  <i class="fa-solid fa-eye"></i> </a>
                                        </div>
                                    </div>
                                </div>
								
								<div class="offer-card mb-3  p-3">
                                    <div class="row">
										
										 <div class="col-md-12 text-center">
                                            <small> সর্বমোট মোবাইল টপ-আপ </small><br>
                                            <small class="fw-bold"> <?php echo htmlspecialchars(number_format($totalMobileTopUp),2); ?> টাকা</small><br>
                                            <a href="work-ongoing.php" class="btn custom-button w-50 mx-auto"> হিস্টোরি  দেখুন  <i class="fa-solid fa-eye"></i> </a>
                                        </div>
									</div>
                                </div>		
								
								<div class="offer-card mb-3  p-3">
                                    <div class="row">
										
										 <div class="col-md-12 text-center">
                                            <small> সর্বমোট মোবাইল ব্যাংকিং </small><br>
                                            <small class="fw-bold"> <?php echo htmlspecialchars(number_format($totalMobileBanking),2); ?> টাকা</small><br>
                                            <a href="work-ongoing.php" class="btn custom-button w-50 mx-auto"> হিস্টোরি  দেখুন  <i class="fa-solid fa-eye"></i> </a>
                                        </div>
									</div>
                                </div>		
										
										
								<div class="offer-card mb-3 p-3">
                                    <div class="row">		
										
										 <div class="col-md-12 text-center">
                                            <small> সর্বমোট  ব্যাংকিং সেবা </small><br>
                                            <small class="fw-bold"> <?php echo htmlspecialchars(number_format($totalBanking),2); ?> টাকা</small><br>
                                            <a href="work-ongoing.php" class="btn custom-button w-50 mx-auto"> হিস্টোরি  দেখুন  <i class="fa-solid fa-eye"></i> </a>
                                        </div>
									</div>
                                </div>		
										
								
								<div class="offer-card mb-3 p-3">
                                    <div class="row">	
										
										<div class="col-md-12 text-center">
                                            <small> সর্বমোট বিল পেমেন্ট </small><br>
                                            <small class="fw-bold"> <?php echo htmlspecialchars(number_format($totalBillPay),2); ?> টাকা</small><br>
                                            <a href="work-ongoing.php" class="btn custom-button w-50 mx-auto"> হিস্টোরি  দেখুন  <i class="fa-solid fa-eye"></i> </a>
                                        </div>
									</div>
                                </div>		
										
								<div class="offer-card mb-3  p-3">
                                    <div class="row">		
										
										<div class="col-md-12 text-center">
                                            <small> সর্বমোট  অফার ক্রয় </small><br>
                                            <small class="fw-bold"> <?php echo htmlspecialchars(number_format($totalPackBuy),2); ?>  টাকা</small><br>
                                            <a href="work-ongoing.php" class="btn custom-button w-50 mx-auto"> হিস্টোরি  দেখুন  <i class="fa-solid fa-eye"></i> </a>
                                        </div>
									</div>
                                </div>		
										
								
										
								<div class="offer-card mb-5  p-3">
                                    <div class="row">	
										<div class="col-md-12 text-center">
                                            <small> সর্বমোট রিসেলার সেন্ড মানি </small><br>
                                            <small class="fw-bold"> <?php echo htmlspecialchars(number_format($totalSendMoney),2); ?> টাকা</small><br>
                                            <a href="work-ongoing.php" class="btn custom-button w-50 mx-auto"> হিস্টোরি  দেখুন  <i class="fa-solid fa-eye"></i> </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</main>

</body>
</html>
